/* ============ */
/* ksfreq.c	*/
/* ============ */
/* -------------------------------- */
/* WorkArea is defined in freqtst.c */
/* -------------------------------- */
#define	RandNum	WorkArea

#define MAX_SAMPS  ((unsigned)RAND_MAX + 1u)

static  int  IntCmprFun(const void *Key, const void *Elem)
{
    return (*(int *) Key - *(int *) Elem);
}
/* ==================================================================== */
/* KSFreq - Kolmogorov-Smirnov Statistics Kn+ & Kn- and Probabilities	*/
/* ==================================================================== */
void
KSFreq(KS_DATA_STRU  *KSData)
{
    UINT    i, J, NumGen;
    double  KSVal, MaxKnMinus, MaxKnPlus, NextKn;

    NumGen = (KSData->SampleSize <= MAX_SAMPS) ?
		KSData->SampleSize : MAX_SAMPS;

    for (i = 0; i < NumGen; ++i)
    {
	int	NextRand = KSData->RandFun();
	RandNum[i] = NextRand;
    }

    /* --------------------------- */
    /* Counting Variates Generated */
    /* --------------------------- */
    KSData->TotNumGen += NumGen;

    /* -------------------------------------- */
    /* Calculate Statistics and Probabilities */
    /* -------------------------------------- */
    qsort((void *)RandNum, NumGen, sizeof(int), IntCmprFun);

    MaxKnMinus = MaxKnPlus = 0;
    for (J = 1; J <= NumGen; ++J)
    {
	KSVal = (double)RandNum[J-1]/(double)MAX_SAMPS;

	NextKn = (double)J/(double)NumGen - KSVal;
	MaxKnPlus = __max(MaxKnPlus, NextKn);

	NextKn = 1.0/(double)NumGen - NextKn;
	MaxKnMinus = __max(MaxKnMinus, NextKn);
    }

    KSData->KnMinus = MaxKnMinus;
    KSData->KnPlus  = MaxKnPlus;

    KSData->KnMinusProb = KSmirnov(NumGen, MaxKnMinus);
    KSData->KnPlusProb  = KSmirnov(NumGen, MaxKnPlus);
}
